!function (t) { var i = t(window); t.fn.visible = function (t, e, o) { if (!(this.length < 1)) { var r = this.length > 1 ? this.eq(0) : this, n = r.get(0), f = i.width(), h = i.height(), o = o ? o : "both", l = e === !0 ? n.offsetWidth * n.offsetHeight : !0; if ("function" == typeof n.getBoundingClientRect) { var g = n.getBoundingClientRect(), u = g.top >= 0 && g.top < h, s = g.bottom > 0 && g.bottom <= h, c = g.left >= 0 && g.left < f, a = g.right > 0 && g.right <= f, v = t ? u || s : u && s, b = t ? c || a : c && a; if ("both" === o) return l && v && b; if ("vertical" === o) return l && v; if ("horizontal" === o) return l && b } else { var d = i.scrollTop(), p = d + h, w = i.scrollLeft(), m = w + f, y = r.offset(), z = y.top, B = z + r.height(), C = y.left, R = C + r.width(), j = t === !0 ? B : z, q = t === !0 ? z : B, H = t === !0 ? R : C, L = t === !0 ? C : R; if ("both" === o) return !!l && p >= q && j >= d && m >= L && H >= w; if ("vertical" === o) return !!l && p >= q && j >= d; if ("horizontal" === o) return !!l && m >= L && H >= w } } } }(jQuery);

(function ($) {

  $.fn.countup = function (params) {

    if (typeof CountUp !== 'function') {
      console.error('countUp.js is a required dependency of countUp-jquery.js.');
      return;
    }

    var defaults = {
      startVal: 0,
      decimals: 0,
      duration: 2,
    };

    if (typeof params === 'number') {
      defaults.endVal = params;
    }
    else if (typeof params === 'object') {
      $.extend(defaults, params);
    }
    else {
      console.error('countUp-jquery requires its argument to be either an object or number');
      return;
    }

    this.each(function (i, elem) {
      var countUp = new CountUp(elem, defaults.startVal, defaults.endVal, defaults.decimals, defaults.duration, defaults.options);

      countUp.start();
    }); return this;

  };

}(jQuery));

(function (root, factory) {
  if (typeof define === 'function' && define.amd) {
    define(factory);
  } else if (typeof exports === 'object') {
    module.exports = factory(require, exports, module);
  } else {
    root.CountUp = factory();
  }
}(this, function (require, exports, module) {


  var CountUp = function (target, startVal, endVal, decimals, duration, options) {

    var self = this;
    self.version = function () { return '1.9.3'; };

    self.options = {
      useEasing: true, 
      useGrouping: true, 
      separator: ',', 
      decimal: '.', 
      easingFn: easeOutExpo, 
      formattingFn: formatNumber, 
      prefix: '', 
      suffix: '',
      numerals: [] 
    };

    if (options && typeof options === 'object') {
      for (var key in self.options) {
        if (options.hasOwnProperty(key) && options[key] !== null) {
          self.options[key] = options[key];
        }
      }
    }

    if (self.options.separator === '') {
      self.options.useGrouping = false;
    }
    else {
     
      self.options.separator = '' + self.options.separator;
    }
    var lastTime = 0;
    var vendors = ['webkit', 'moz', 'ms', 'o'];
    for (var x = 0; x < vendors.length && !window.requestAnimationFrame; ++x) {
      window.requestAnimationFrame = window[vendors[x] + 'RequestAnimationFrame'];
      window.cancelAnimationFrame = window[vendors[x] + 'CancelAnimationFrame'] || window[vendors[x] + 'CancelRequestAnimationFrame'];
    }
    if (!window.requestAnimationFrame) {
      window.requestAnimationFrame = function (callback, element) {
        var currTime = new Date().getTime();
        var timeToCall = Math.max(0, 16 - (currTime - lastTime));
        var id = window.setTimeout(function () { callback(currTime + timeToCall); }, timeToCall);
        lastTime = currTime + timeToCall;
        return id;
      };
    }
    if (!window.cancelAnimationFrame) {
      window.cancelAnimationFrame = function (id) {
        clearTimeout(id);
      };
    }

    function formatNumber(num) {
      var neg = (num < 0),
        x, x1, x2, x3, i, len;
      num = Math.abs(num).toFixed(self.decimals);
      num += '';
      x = num.split('.');
      x1 = x[0];
      x2 = x.length > 1 ? self.options.decimal + x[1] : '';
      if (self.options.useGrouping) {
        x3 = '';
        for (i = 0, len = x1.length; i < len; ++i) {
          if (i !== 0 && ((i % 3) === 0)) {
            x3 = self.options.separator + x3;
          }
          x3 = x1[len - i - 1] + x3;
        }
        x1 = x3;
      }
      
      if (self.options.numerals.length) {
        x1 = x1.replace(/[0-9]/g, function (w) {
          return self.options.numerals[+w];
        })
        x2 = x2.replace(/[0-9]/g, function (w) {
          return self.options.numerals[+w];
        })
      }
      return (neg ? '-' : '') + self.options.prefix + x1 + x2 + self.options.suffix;
    }
    
    function easeOutExpo(t, b, c, d) {
      return c * (-Math.pow(2, -10 * t / d) + 1) * 1024 / 1023 + b;
    }
    function ensureNumber(n) {
      return (typeof n === 'number' && !isNaN(n));
    }

    self.initialize = function () {
      if (self.initialized) return true;

      self.error = '';
      self.d = (typeof target === 'string') ? document.getElementById(target) : target;
      if (!self.d) {
        self.error = '[CountUp] target is null or undefined'
        return false;
      }
      self.startVal = Number(startVal);
      self.endVal = Number(endVal);
      
      if (ensureNumber(self.startVal) && ensureNumber(self.endVal)) {
        self.decimals = Math.max(0, decimals || 0);
        self.dec = Math.pow(10, self.decimals);
        self.duration = Number(duration) * 1000 || 2000;
        self.countDown = (self.startVal > self.endVal);
        self.frameVal = self.startVal;
        self.initialized = true;
        return true;
      }
      else {
        self.error = '[CountUp] startVal (' + startVal + ') or endVal (' + endVal + ') is not a number';
        return false;
      }
    };

  
    self.printValue = function (value) {
      var result = self.options.formattingFn(value);

      if (self.d.tagName === 'INPUT') {
        this.d.value = result;
      }
      else if (self.d.tagName === 'text' || self.d.tagName === 'tspan') {
        this.d.textContent = result;
      }
      else {
        this.d.innerHTML = result;
      }
    };

    self.count = function (timestamp) {

      if (!self.startTime) { self.startTime = timestamp; }

      self.timestamp = timestamp;
      var progress = timestamp - self.startTime;
      self.remaining = self.duration - progress;

      
      if (self.options.useEasing) {
        if (self.countDown) {
          self.frameVal = self.startVal - self.options.easingFn(progress, 0, self.startVal - self.endVal, self.duration);
        } else {
          self.frameVal = self.options.easingFn(progress, self.startVal, self.endVal - self.startVal, self.duration);
        }
      } else {
        if (self.countDown) {
          self.frameVal = self.startVal - ((self.startVal - self.endVal) * (progress / self.duration));
        } else {
          self.frameVal = self.startVal + (self.endVal - self.startVal) * (progress / self.duration);
        }
      }


      if (self.countDown) {
        self.frameVal = (self.frameVal < self.endVal) ? self.endVal : self.frameVal;
      } else {
        self.frameVal = (self.frameVal > self.endVal) ? self.endVal : self.frameVal;
      }

  
      self.frameVal = Math.round(self.frameVal * self.dec) / self.dec;


      self.printValue(self.frameVal);


      if (progress < self.duration) {
        self.rAF = requestAnimationFrame(self.count);
      } else {
        if (self.callback) self.callback();
      }
    };

    self.start = function (callback) {
      if (!self.initialize()) return;
      self.callback = callback;
      self.rAF = requestAnimationFrame(self.count);
    };

    self.pauseResume = function () {
      if (!self.paused) {
        self.paused = true;
        cancelAnimationFrame(self.rAF);
      } else {
        self.paused = false;
        delete self.startTime;
        self.duration = self.remaining;
        self.startVal = self.frameVal;
        requestAnimationFrame(self.count);
      }
    };
  
    self.reset = function () {
      self.paused = false;
      delete self.startTime;
      self.initialized = false;
      if (self.initialize()) {
        cancelAnimationFrame(self.rAF);
        self.printValue(self.startVal);
      }
    };
   
    self.update = function (newEndVal) {
      if (!self.initialize()) return;
      newEndVal = Number(newEndVal);
      if (!ensureNumber(newEndVal)) {
        self.error = '[CountUp] update() - new endVal is not a number: ' + newEndVal;
        return;
      }
      self.error = '';
      if (newEndVal === self.frameVal) return;
      cancelAnimationFrame(self.rAF);
      self.paused = false;
      delete self.startTime;
      self.startVal = self.frameVal;
      self.endVal = newEndVal;
      self.countDown = (self.startVal > self.endVal);
      self.rAF = requestAnimationFrame(self.count);
    };

    if (self.initialize()) self.printValue(self.startVal);
  };

  return CountUp;

}));